/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.mssql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jtbcore.db.model.ColumnModel;
import jtbcore.db.model.DatabaseModel;
import jtbcore.db.model.TableModel;
import jtbcore.db.mssql.MSSqlConnection;
import jtbcore.db.sql.SqlColumn;
import jtbcore.db.sql.SqlDatabase;
import jtbcore.db.sql.SqlTable;
import jtbcore.model.BaseStringMap;

public class MSSqlTableModelGenerator {
    protected DatabaseModel model;
    protected SqlDatabase sqlDb = new SqlDatabase();
    protected List<String> updateQueries;

    public MSSqlTableModelGenerator() {
    }

    public MSSqlTableModelGenerator(DatabaseModel model) {
        this.setModel(model);
    }

    public DatabaseModel getModel() {
        return this.model;
    }

    public void setModel(DatabaseModel model) {
        this.model = model;
    }

    public String generateCreateTable(String tableName) {
        TableModel tm = this.getModel().getTable(tableName);
        List<ColumnModel> cols = tm.getColumns();
        StringBuilder b = new StringBuilder();
        b.append("CREATE TABLE ");
        b.append("[" + tm.getName() + "]");
        b.append(" (\n");
        int cnt = 0;
        for (ColumnModel cm : cols) {
            String type = this.dbtype(cm.getType());
            b.append("    [").append(cm.getName()).append("] ").append(type);
            if (cm.isPrimaryKey()) {
                b.append(" PRIMARY KEY ");
            }
            if (cm.isUnique()) {
                b.append(" UNIQUE ");
            }
            if (cm.isAutoIncrement()) {
                b.append(" IDENTITY ");
            }
            if (cnt < cols.size() - 1) {
                b.append(",");
            }
            b.append("\n");
            ++cnt;
        }
        b.append(")\n");
        return b.toString();
    }

    public String generateAddColumn(String tableName, ColumnModel cm) {
        String sql = "ALTER TABLE [" + tableName + "] ADD COLUMN [" + cm.getName() + "] " + this.dbtype(cm.getType());
        return sql;
    }

    public List<TableModel> updateSchema(MSSqlConnection con) throws SQLException, IOException {
        TableModel tm;
        ArrayList<TableModel> updatedTables = new ArrayList<TableModel>();
        this.updateQueries = new ArrayList<String>();
        Map<String, TableModel> tablesModel = this.model.getTables();
        SqlDatabase sqlDb = this.mssqlToSqlDatabaseModelOnly(con);
        for (String tblInModel : tablesModel.keySet()) {
            if (sqlDb.getTable(tblInModel) != null || !(tm = tablesModel.get(tblInModel)).isAutogenerated()) continue;
            String sqlCreate = this.generateCreateTable(tblInModel);
            this.updateQueries.add(sqlCreate);
            if (updatedTables.contains(tm)) continue;
            updatedTables.add(tm);
        }
        for (SqlTable st : sqlDb.getTables()) {
            tm = tablesModel.get(st.getName());
            if (tm == null) continue;
            for (ColumnModel cm : tm.getColumns()) {
                if (st.getColumnByName(cm.getName()) != null) continue;
                String sqlAdd = this.generateAddColumn(tm.getName(), cm);
                System.out.println(sqlAdd);
                this.updateQueries.add(sqlAdd);
                if (updatedTables.contains(tm)) continue;
                updatedTables.add(tm);
            }
        }
        for (String q : this.updateQueries) {
            try {
                con.query(q, new Object[0]);
            }
            catch (Exception ex) {
                System.err.println("Failed query: " + q);
                throw ex;
            }
        }
        return updatedTables;
    }

    public SqlTable buildSqlTable(MSSqlConnection con, String tblSchema, String tblName) throws SQLException {
        String databaseName = con.getDatabaseName();
        if (tblSchema == null) {
            List recTables = con.queryList("select * from INFORMATION_SCHEMA.TABLES  where TABLE_CATALOG = ?    and TABLE_NAME = ? \t and TABLE_TYPE = 'BASE TABLE' ", databaseName, tblName);
            tblSchema = ((BaseStringMap)recTables.get(0)).getProperty("TABLE_SCHEMA");
        }
        List recPks = con.queryList("SELECT ccu.COLUMN_NAME FROM INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE ccu JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS ts on (ccu.CONSTRAINT_NAME = ts.CONSTRAINT_NAME) WHERE     ccu.TABLE_CATALOG = ?     AND ccu.TABLE_NAME=?     AND ts.CONSTRAINT_TYPE='PRIMARY KEY'", databaseName, tblName);
        ArrayList<String> pks = new ArrayList<String>();
        for (BaseStringMap bsm : recPks) {
            pks.add(bsm.getProperty("COLUMN_NAME"));
        }
        List cols = con.queryList("SELECT COLUMNPROPERTY( object_id(c.TABLE_CATALOG+'.'+c.TABLE_SCHEMA+'.'+c.TABLE_NAME), c.COLUMN_NAME, 'IsIdentity') isIdentity, c.* FROM INFORMATION_SCHEMA.COLUMNS c WHERE c.TABLE_CATALOG = ?  AND c.TABLE_SCHEMA = ?  AND c.TABLE_NAME = ?", databaseName, tblSchema, tblName);
        SqlTable table = new SqlTable(tblName);
        table.setSchemaName(tblSchema);
        for (BaseStringMap col : cols) {
            boolean isIdentity = false;
            if ("1".equals(col.getProperty("isIdentity"))) {
                isIdentity = true;
            }
            SqlColumn scol = new SqlColumn();
            scol.name = col.getProperty("COLUMN_NAME");
            scol.sqlDatatype = col.getProperty("DATA_TYPE");
            if ("varchar".equals(scol.sqlDatatype)) {
                scol.sqlDatatype = scol.sqlDatatype + "(" + col.getProperty("CHARACTER_MAXIMUM_LENGTH") + ")";
                Integer maxlen = col.getPropertyInt("CHARACTER_MAXIMUM_LENGTH");
                if (maxlen != null) {
                    scol.maxLen = maxlen;
                }
            }
            scol.primaryKey = pks.contains(scol.name);
            scol.autoincrement = isIdentity;
            scol.internalType = this.internalDataType(col.getProperty("DATA_TYPE"));
            table.setColumn(scol);
        }
        return table;
    }

    public SqlDatabase mssqlToSqlDatabaseModelOnly(MSSqlConnection con) throws IOException, SQLException {
        String databaseName = con.getDatabaseName();
        SqlDatabase db = new SqlDatabase();
        for (TableModel tm : this.model.getTables().values()) {
            List recTables = con.queryList("select * from INFORMATION_SCHEMA.TABLES  where TABLE_CATALOG = ?    and TABLE_NAME = ? \t and TABLE_TYPE = 'BASE TABLE' ", databaseName, tm.getName());
            for (BaseStringMap recTbl : recTables) {
                String tblName2 = recTbl.getProperty("TABLE_NAME");
                String tblSchema = recTbl.getProperty("TABLE_SCHEMA");
                SqlTable st = this.buildSqlTable(con, tblSchema, tblName2);
                db.addTable(st);
            }
        }
        return db;
    }

    public SqlDatabase mssqlToSqlDatabase(MSSqlConnection con) throws IOException, SQLException {
        String databaseName = con.getDatabaseName();
        List recTables = con.queryList("select * from INFORMATION_SCHEMA.TABLES  where TABLE_CATALOG = ?  \t and TABLE_TYPE = 'BASE TABLE' ", databaseName);
        SqlDatabase db = new SqlDatabase();
        for (BaseStringMap recTbl : recTables) {
            String tblName = recTbl.getProperty("TABLE_NAME");
            String tblSchema = recTbl.getProperty("TABLE_SCHEMA");
            SqlTable st = this.buildSqlTable(con, tblSchema, tblName);
            db.addTable(st);
        }
        return db;
    }

    public SqlColumn.DataType internalDataType(String dataType) {
        switch (dataType) {
            case "numeric": 
            case "bigint": 
            case "smallint": 
            case "int": 
            case "decimal": {
                return SqlColumn.DataType.NUMERIC;
            }
            case "tinyint": 
            case "bit": {
                return SqlColumn.DataType.BOOLEAN;
            }
            case "double": 
            case "real": 
            case "float": 
            case "money": 
            case "smallmoney": {
                return SqlColumn.DataType.REAL;
            }
            case "smalldatetime": 
            case "datetime2": 
            case "date": 
            case "time": 
            case "datetimeoffset": 
            case "datetime": {
                return SqlColumn.DataType.DATE;
            }
            case "nvarchar": 
            case "char": 
            case "text": 
            case "nchar": 
            case "ntext": 
            case "varchar": {
                return SqlColumn.DataType.TEXT;
            }
            case "binary": 
            case "varbinary": 
            case "image": {
                return SqlColumn.DataType.TEXT;
            }
        }
        return SqlColumn.DataType.TEXT;
    }

    public String dbtype(String modelType) {
        if ((modelType = modelType.toLowerCase()).startsWith("varchar")) {
            return modelType;
        }
        if ("text".equals(modelType)) {
            return "text";
        }
        if ("longtext".equals(modelType)) {
            return "longtext";
        }
        if ("bool".equals(modelType) || "boolean".equals(modelType)) {
            return "tinyint";
        }
        if ("int".equals(modelType) || "int32".equals(modelType)) {
            return "int";
        }
        if ("int64".equals(modelType) || "bigint".equals(modelType) || "long".equals(modelType)) {
            return "bigint";
        }
        if ("double".equals(modelType)) {
            return "real";
        }
        if ("float".equals(modelType)) {
            return "float";
        }
        if ("blob".equals(modelType)) {
            return "BLOB";
        }
        if ("date".equals(modelType)) {
            return "date";
        }
        if ("datetime".equals(modelType)) {
            return "datetime";
        }
        return "text";
    }
}

